//
//  OPItem+Image.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-08-13.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

#import "OPItem.h"
#import "B5CustomIconAttributes.h"

@interface OPItem (Image)

// Universal
- (BOOL)hasCustomIcon;
- (BOOL)useOverlayInCustomIcon;

// Remove all custom icon information
- (void)removeAllCustomIconData;

- (void)removeOP4CustomIconData;
- (void)removeB5CustomIconData;
- (void)removeB5PendingCustomIconData;

// Remove pending custom icon information from export
- (void)removePendingIconFromAttributesDictionary:(NSMutableDictionary *)dictionary;

- (void)setCustomIconImage:(OPImage *)image fileData:(NSData *)imageData;

// Overview based customIcon
- (OPImage *)_customIcon;
- (NSData *)_customIconData;

// Server based Icons
- (NSData *)pendingCustomIcon;
- (B5CustomIconAttributes *)customIconAttributes;
- (void)setCustomIconAttributes:(B5CustomIconAttributes *)attributes;

- (void)commitPendingCustomIconFileForUploadIfNeeded;

@end
